$(document).ready(function() {

    $(".date_picker").datetimepicker({
        format: 'MM/DD/YYYY'
    });
    $('.time_picker').datetimepicker({
        format: 'HH:mm',
        locale: 'en'
    });

    $(document).on('click','.input-group-addon',function(){
        $(this).siblings('.date_picker').focus();
    })

    $(document).on('click','.btn-filter',function(){
        show_ajax();
    })

    $(document).on('focus','.schedule_filter.date_picker',function(){
        $('#inlineRadio2').trigger('click');
    })

    $(document).on('click','#allow_registered',function(){
        var $obj = $('#swith-registered');

        setTimeout(function(){
            $('[name="allow_registered"]').val(($($obj).hasClass('checked')) ? '1' : '0');
        },500);
    })

    /* Delete user */
    $(document).on('click','#delete_user',function(e){
        e.preventDefault();
        if(confirm('Do you really want to delete this user ?')) {
            $.ajax({
                url: 'ajax.php',
                dataType: 'json',
                type: 'POST',
                data: {action_function: 'delete_user', uid: $(this).attr('data-id')},
                'beforeSend' : function(){ show_ajax();},
                'complete' : function() { hide_ajax();},
                'success': function (data) {

                    if (data.status == 1) {
                        window.location.reload();
                    };

                    if (data.status == 2) {
                        alert(data.message);
                    };

                },
                'error': function () {
                    console.log('error');
                }
            })
        }
    });

    /* Enable/Disable User */
    $(document).on('click','#change_user_status',function(e){
        e.preventDefault();
        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'change_user_status', uid: $(this).attr('data-id')},
            'beforeSend' : function(){ show_ajax();},
            'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    window.location.reload();
                };

                if (data.status == 2) {
                    alert(data.message);
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    });

    /* Delete Schedule*/
    $(document).on('click','#delete_schedule',function(event){
        event.preventDefault();
        var sid = $(this).attr('data-id');

        if(confirm('Do you really want to delete this scheduler?')) {
            $.ajax({
                url: 'ajax.php',
                dataType: 'json',
                type: 'POST',
                data: {action_function: 'delete_schedule', sid: sid},
                'beforeSend': function () {
                    show_ajax();
                },
                'complete': function () {
                    hide_ajax();
                },
                'success': function (data) {

                    if (data.status == 1) {
                        $('tr[data-id="' + sid + '"]').fadeOut('slow');
                    }
                    ;

                    if (data.status == 2) {
                        alert(data.message);
                    }
                    ;

                },
                'error': function () {
                    console.log('error');
                }
            })
        }
    })

    /* Edit Schedule*/
    $(document).on('click','#edit_schedule',function(event){
        event.preventDefault();
        var sid = $(this).attr('data-id');

        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'edit_schedule', sid: sid},
            'beforeSend': function () {
                show_ajax();
            },
            'complete': function () {
                hide_ajax();
            },
            'success': function (data) {

                if (data.status == 1) {
                    window.location.href = data.url;
                }
                ;

                if (data.status == 2) {
                    alert(data.message);
                }
                ;

            },
            'error': function () {
                console.log('error');
            }
        })
    })

    /* Edit User*/
    $(document).on('click','#edit_user',function(event){
        event.preventDefault();
        $('input[name="uid"]').val($(this).attr('data-id'));
        $('#edit_user_form').trigger('submit');
    })

    /* Select Page*/
    $(document).on('click','.choose_page',function(){
        $(this).toggleClass('btn-success');
        $('.errors_block').html('');
    })

    /* Select Posts*/
    $(document).on('click','.select_post',function(event){
        event.preventDefault();
        $(this).toggleClass('btn-success');
        $('.errors_block').html('');
    })

    /* when link clicked*/
    $(document).on('click','a.app_link',function(){
        show_ajax();
    })

    /* Next Step 0*/
    $(document).on('click','#next_step0',function(event){
        event.preventDefault();

        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'next_step0', post_type: $(this).attr('data-id')},
            'beforeSend' : function(){ show_ajax();},
            //'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    window.location.reload();
                };

                if (data.status == 2) {
                    hide_ajax();
                    alert(data.message);
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })

    /* Next Step 1*/
    $(document).on('click','#next_step1',function(event){
        event.preventDefault();
        var $pages = [];
        $('.choose_page.btn-success').each(function(){
            $pages.push($(this).attr('data-id'));
        })

        if($pages.length == 0){
            $('.errors_block').html('<div class="alert alert-info alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>Select Fan Page.</div>');
        }else{
            $.ajax({
                url: 'ajax.php',
                dataType: 'json',
                type: 'POST',
                data: {action_function: 'next_step1', pages: $pages},
                'beforeSend' : function(){ show_ajax();},
                'complete' : function() { hide_ajax();},
                'success': function (data) {

                    if (data.status == 1) {
                        window.location.reload();
                    };

                    if (data.status == 2) {
                        $('.errors_block').html('<div class="alert alert-info alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+data.message+'</div>');
                    };

                },
                'error': function () {
                    console.log('error');
                }
            })
        }
    })

    /* Select Post*/
    $(document).on('click','.select_condition',function(event){
        event.preventDefault();
        $('.select_condition').removeClass('btn-success');
        $(this).addClass('btn-success');
    })

    /* Next Step 2*/
    $(document).on('click','[name="next_step2"]',function(event){
        event.preventDefault();
        var condition = $(this).attr('data-id');
        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'next_step2', condition: condition},
            'beforeSend' : function(){ show_ajax();},
            //'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    window.location.reload();
                };

                if (data.status == 2) {
                    $('.errors_block').html('<div class="alert alert-info alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+data.message+'</div>');
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })

    /* Next Step 3*/
    $(document).on('click','#next_step3',function(event){
        event.preventDefault();
        var condition = $(this).attr('data-id');
        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'next_step3', add_condition: condition},
            'beforeSend' : function(){ show_ajax();},
            'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    window.location.reload();
                };

                if (data.status == 2) {
                    $('.errors_block').html('<div class="alert alert-info alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+data.message+'</div>');
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })

    /* Next Step 3_1*/
    $(document).on('click','#next_step_31',function(event){
        event.preventDefault();
        var posts = [];

        $('.select_post.btn-success').each(function(){
            posts.push($(this).attr('data-id'));
        })

        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'next_step31', posts: posts},
            'beforeSend' : function(){ show_ajax();},
            'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    window.location.reload();
                };

                if (data.status == 2) {
                    $('.errors_block').html('<div class="alert alert-info alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+data.message+'</div>');
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })

    /* Next Step 4*/
    $(document).on('click','#next_step4',function(event){
        event.preventDefault();
        var keyword = $('[name="keyword"]').val();
        var comment = $('[name="comment"]').val();

        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'next_step4', keyword: keyword, comment: comment},
            'beforeSend' : function(){ show_ajax();},
            'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    window.location.reload();
                };

                if (data.status == 2) {
                    $('.errors_block').html('<div class="alert alert-info alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+data.message+'</div>');
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })

    /*Load More Groups*/
    $(document).on('click','#load_more_groups',function(event){
        event.preventDefault();

        var $obj = $(this);
        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'load_more_groups', offset: $(this).attr('data-id')},
            'beforeSend' : function(){ show_ajax();},
            'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    $('table tbody').append(data.html);
                    $($obj).attr('data-id',data.offset);
                };

                if (data.status == 2) {
                    $($obj).remove();
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })

    /*Load More Schedules*/
    $(document).on('click','#load_more_schedules',function(event){
        event.preventDefault();

        var $obj = $(this);
        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'load_more_schedules', offset: $(this).attr('data-id')},
            'beforeSend' : function(){ show_ajax();},
            'complete' : function() { hide_ajax();},
            'success': function (data) {
                if (data.status == 1) {
                    $('table tbody').append(data.html);
                    $($obj).attr('data-id',data.offset);
                };

                if (data.status == 2) {
                    $($obj).remove();
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })

    /* Load More Posts*/
    $(document).on('click','#load_more_posts',function(event){
        event.preventDefault();

        var $obj = $(this);
        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'load_more_posts', offset: $(this).attr('data-id')},
            'beforeSend' : function(){ show_ajax();},
            'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    $('table tbody').append(data.html);
                    $($obj).attr('data-id',data.offset);
                };

                if (data.status == 2) {
                    $($obj).remove();
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })

})

function show_ajax()
{
    hide_ajax();
    $('main').append('<div class="ajax-loader full_page">');
};

function hide_ajax()
{
    $('.ajax-loader').remove();
}
